<?php
class ConfManager {
    static private $xml     = null ;
    static private $db_conn = null ;

    static function load() {
        if( file_exists( Constants::DTASCFG_XML_FILE ) == false ) {
            throw new Exception( "FileNotExist: " . Constants::DTASCFG_XML_FILE ) ;
        }

        if( self::$xml === null  ) {
            self::$xml = simplexml_load_file( Constants::DTASCFG_XML_FILE ) ;
        }
    }

    static function getDbConnection() {
        if( self::$db_conn !== null ) {
            return self::$db_conn ;
        }
        
        $db_host     = self::get( "/configuration/db/host" ) ;
        $db_username = self::get( "/configuration/db/username" ) ;
        
        $sql = "host=$db_host dbname=dtasdb port=5432 user=$db_username" ;
        if( ( self::$db_conn = pg_connect( $sql ) ) == false ) {
            throw new Exception( "FailToConnectDb: host=$db_host" ) ;
        }
        
        return self::$db_conn ;
    }
    
    static function transXpathToDbFormat( $xpath ) {
        return str_replace( "/", ".", substr( $xpath, 1 ) ) ;
    }
    
    static function isExist( $xpath ) {
        self::load() ;
        
        $values = self::$xml -> xpath( $xpath ) ;
        if( count( $values ) == 0 ) {
            return false ;
        }
        
        return true ;
    }
    
    static function get( $xpath, $index = 0 ) {
        self::load() ;

        if( self::isExist( $xpath ) == false ) {
            throw new Exception( "XpathNotExist: $xpath" ) ;
        }
        
        $values = self::$xml -> xpath( $xpath ) ;
        return (string) $values[ $index ] ;
    }
    
    static function add( $xpath, $value ) {
        if( pg_query_params( self::getDbConnection(),
                             'INSERT INTO tb_global_setting (key, value) VALUES($1,$2)',
                             array( self::transXpathToDbFormat( $xpath ), $value ) ) == false ) {
                             
            throw new Exception( "FailToInsertConfiguration: key=$xpath, value=$value, msg=" . pg_last_error() ) ;
        }
    }
    
    static function update( $xpath, $value ) {
        if( pg_query_params( self::getDbConnection(),
                             'UPDATE tb_global_setting SET value=$2 WHERE key=$1',
                             array( self::transXpathToDbFormat( $xpath ), $value ) ) == false ) {
                             
            throw new Exception( "FailToUpdateConfiguration: key=$xpath, value=$value, msg=" . pg_last_error() ) ;
        }
    }
    
    static function set( $xpath, $value ) {
        self::load() ;
        
        if( self::isExist( $xpath ) == true ) {
            self::update( $xpath, $value ) ;
        }
        
        else {
            self::add( $xpath, $value ) ;
        }
    }

    static function setToXml( $xpath, $value ) {
    }
    
    static function reload() {
        if( file_exists( Constants::DTASCFG_XML_FILE ) == false ) {
            throw new Exception( "FileNotExist: " . Constants::DTASCFG_XML_FILE ) ;
        }

        # MS ip might change
        self::$db_conn = null ;
        self::$xml     = simplexml_load_file( Constants::DTASCFG_XML_FILE ) ;
    }
    
    static function notify() {
    
        # 1. update version number in db 
        # 2. sync /etc/dtascfg.xml with db
        # 3. notify MS's daemons to reload /etc/dtascfg.xml
        $result = array() ;
        $commands = array(
            "/usr/bin/php /opt/TrendMicro/DTAS/ManagementServer/bin/update_config_ver.php",
            "/usr/bin/php /opt/TrendMicro/DTAS/ManagementServer/bin/config_sync.php -c /etc/dtascfg.xml -a db2xml -o /etc/dtascfg.xml",
            "/bin/sh /opt/TrendMicro/DTAS/ManagementServer/bin/reload_config.sh" ) ;

        foreach( $commands as $command ) {
            exec( $command, $result_array, $return_value ) ;

            if( $return_value != 0 ) {
                throw new Exception(
                    "FailToNotifyConfigurationChange: FailToRunCommand: " . join( " ", $result_array ) ) ;
            }
            
            CommonUtility::debug_print( "SuccessToRunCommand: $command\n" ) ;
        }
        
        self::reload() ;
    }

    
    static function getMsInfo( $sc_id ) {
        $result = array() ;
        try {
            if( true ) {
                $result[ "username" ]       = self::get( "/configuration/management_server/admin_username" ) ;
                $result[ "password" ]       = self::get( "/configuration/management_server/admin_password" ) ;
                $result[ "ip" ]             = self::get( "/configuration/management_server/ip" ) ;
                $result[ "dns" ]            = self::get( "/configuration/management_server/dns" ) ;
                $result[ "gateway" ]        = self::get( "/configuration/management_server/gateway" ) ;
                $result[ "netmask" ]        = self::get( "/configuration/management_server/netmask" ) ;
                // $result[ "image_path" ]     = self::get( "/configuration/management_server/image_path" ) ;
                // $result[ "image_path_vix" ] = self::get( "/configuration/management_server/image_path_vix" ) ;
                
                $result[ "internal_nic" ]     = self::get( "/configuration/management_server/internal/nic" ) ;
                $result[ "internal_dhcp" ]    = self::get( "/configuration/management_server/internal/dhcp" ) ;
                $result[ "internal_ip" ]      = self::get( "/configuration/management_server/internal/ip" ) ;
                $result[ "internal_dns" ]     = self::get( "/configuration/management_server/internal/dns" ) ;
                $result[ "internal_gateway" ] = self::get( "/configuration/management_server/internal/gateway" ) ;
                $result[ "internal_netmask" ] = self::get( "/configuration/management_server/internal/netmask" ) ;
                
                // using '127.0.0.1' when ms ip is empty.
                $ms_ip = $result[ "ip" ] ;
                if( $ms_ip === null || $ms_ip === "" ) {
                    dprint( 0, LOG_WARNING, "MS ip is empty: ms_ip='$ms_ip'", "GetMsInfo" ) ;
                    dprint( 0, LOG_WARNING, "Using '127.0.0.1' as MS ip", "GetMsInfo" ) ;
                    $result[ "ip" ] = "127.0.0.1" ;
                }
            }
            
            else {
                throw new Exception( "NotImplementedYet: id='$sc_id'" ) ;
            }
        }
        
        catch( Exception $e ) {
            $msg = $e -> getMessage() ;
            CommonUtility::debug_print( $msg ) ;
            throw new Exception( $msg ) ;
        }
        
        return $result ;
    }
    
    static function getScInfo( $sc_id ) {
        $result = array() ;
        try {
            if( $sc_id == 1 ) {
                $result[ "name" ]           = "master" ;
                $result[ "esxi_ip" ]        = self::get( "/configuration/esxi/ip" ) ;
                $result[ "esxi_username" ]  = self::get( "/configuration/esxi/username" ) ;
                $result[ "esxi_password" ]  = self::get( "/configuration/esxi/password" ) ;
                $result[ "username" ]       = self::get( "/configuration/sandbox_controller/admin_username" ) ;
                $result[ "password" ]       = self::get( "/configuration/sandbox_controller/admin_password" ) ;
                $result[ "ip" ]             = self::get( "/configuration/sandbox_controller/ip" ) ;
                $result[ "port" ]           = 22 ;
                $result[ "dns" ]            = self::get( "/configuration/sandbox_controller/dns" ) ;
                $result[ "gateway" ]        = self::get( "/configuration/sandbox_controller/gateway" ) ;
                $result[ "netmask" ]        = self::get( "/configuration/sandbox_controller/netmask" ) ;
                $result[ "image_path" ]     = self::get( "/configuration/sandbox_controller/image_path" ) ;
                $result[ "image_path_vix" ] = self::get( "/configuration/sandbox_controller/image_path_vix" ) ;
            }
            else {
                $result[ "name" ]           = self::get( "/configuration/cluster_${sc_id}/name" ) ;
                $result[ "esxi_ip" ]        = self::get( "/configuration/cluster_${sc_id}/esxi/ip" ) ;
                $result[ "esxi_username" ]  = self::get( "/configuration/cluster_${sc_id}/esxi/username" ) ;
                $result[ "esxi_password" ]  = self::get( "/configuration/cluster_${sc_id}/esxi/password" ) ;
                $result[ "username" ]       = self::get( "/configuration/cluster_${sc_id}/sandbox_controller/admin_username" ) ;
                $result[ "password" ]       = self::get( "/configuration/cluster_${sc_id}/sandbox_controller/admin_password" ) ;
                $result[ "ip" ]             = self::get( "/configuration/cluster_${sc_id}/sandbox_controller/ip" ) ;
                $result[ "port" ]           = 1122 ;
                $result[ "dns" ]            = self::get( "/configuration/cluster_${sc_id}/sandbox_controller/dns" ) ;
                $result[ "gateway" ]        = self::get( "/configuration/cluster_${sc_id}/sandbox_controller/gateway" ) ;
                $result[ "netmask" ]        = self::get( "/configuration/cluster_${sc_id}/sandbox_controller/netmask" ) ;
                $result[ "image_path" ]     = self::get( "/configuration/cluster_${sc_id}/sandbox_controller/image_path" ) ;
                $result[ "image_path_vix" ] = self::get( "/configuration/cluster_${sc_id}/sandbox_controller/image_path_vix" ) ;
            }
        }
        
        catch( Exception $e ) {
            $msg = $e -> getMessage() ;
            CommonUtility::debug_print( $msg ) ;
            throw new Exception( $msg ) ;
        }
        
        return $result ;
    }
    
    static function getEsxiInfo( $sc_id ) {
        $result = array() ;
        try {
            if( $sc_id == 1 ) {
                $result[ "ip" ]       = self::get( "/configuration/esxi/ip" ) ;
                $result[ "port" ]     = 443 ;
                $result[ "username" ] = self::get( "/configuration/esxi/username" ) ;
                $result[ "password" ] = self::get( "/configuration/esxi/password" ) ;
            }
            else {
                $result[ "ip" ]       = self::get( "/configuration/cluster_${sc_id}/esxi/ip" ) ;
                $result[ "port" ]     = 10443 ;
                $result[ "username" ] = self::get( "/configuration/cluster_${sc_id}/esxi/username" ) ;
                $result[ "password" ] = self::get( "/configuration/cluster_${sc_id}/esxi/password" ) ;
            }
        }
        
        catch( Exception $e ) {
            $msg = $e -> getMessage() ;
            CommonUtility::debug_print( $msg ) ;
            throw new Exception( $msg ) ;
        }
        
        return $result ;
    }
}

if( realpath( $_SERVER[ "SCRIPT_NAME" ] ) == realpath( __FILE__ ) ) {
    require_once( "Constants.class.php" ) ;
    
    try {
        echo ConfManager::get( "/configuration/db/host" ) . "\n" ;
        ConfManager::set( "/configuration/db/host", "10.1.117.92" ) ;
        ConfManager::notify() ;
        echo ConfManager::get( "/configuration/db/host" ) . "\n" ;
    }
    
    catch ( Exception $e ) {
        echo "[" . $e -> getFile() . "(" . $e -> getLine() . ")]: " . $e -> getMessage() . "\n" ;
    }
}
